<?php

namespace App\Http\Controllers\Charts;

use App\Models\Resource;
use Illuminate\Http\Request;
use App\Builders\ChartBuilder;
use App\Services\ChartService;
use App\Http\Controllers\Controller;

class ChartBuildController extends Controller
{
    public $chartService;

    public function __construct(ChartService $chartService)
    {
        $this->chartService = $chartService;

    }
    public function __invoke(Resource $chart)
    {
        $this->chartService->buildChart($chart);
        return $chart;
    }
}
