<?php

namespace App\Http\Controllers\Charts\Wizard;

use App\Models\Resource;
use App\Services\ChartService;
use App\Http\Controllers\Controller;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\Chart\DataStepRequest;
use App\Http\Requests\Chart\DataStepUpdateRequest;

class DataStepController extends Controller
{
    public $chartService;
    public function __construct(ChartService $chartService)
    {
        $this->chartService = $chartService;
        $this->middleware(OnlyFullVersion::class)->only([
            'store',
            'update'
        ]);

    }

    public function store(DataStepRequest $request)
    {
        $this->chartService->storeDataStep($request);

        return response()->json([
            'success'
        ]);
    }

    public function update(DataStepUpdateRequest $request, Resource $chart)
    {
        $this->chartService->updateDataStep($request, $chart);

        return response()->json([
            'success'
        ]);
    }
}
