<?php

namespace App\Http\Controllers;

use App\Models\Group;
use Illuminate\Http\Request;
use App\Services\GroupService;
use App\Services\ModuleService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\storeGroupRequest;
use App\Http\Requests\updateGroupRequest;

class GroupController extends Controller
{

    public $groupService;
    public $moduleService;
    public function __construct(GroupService $groupService, ModuleService $moduleService)
    {
        $this->groupService = $groupService;
        $this->moduleService = $moduleService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'store',
                'update',
                'destroy',
            ]
        );
    }

    public function store(storeGroupRequest $request)
    {
        $this->groupService->store($request);

        return response()->json([
            'message' => trans('users.group_saved')
        ]);
    }

    public function edit(Group $group)
    {
        $group->load('module_permissions', 'resource_permissions');
        $modules = $this->moduleService->getAllWithResources(['is_active' => true, 'parent_id' => null]);
        return view('dashboard.users.group.edit', compact('group', 'modules'));
    }

    public function update(Group $group, updateGroupRequest $request)
    {
        $this->groupService->update($request, $group);

        return response()->json([
            'message' => trans('users.group_saved')
        ]);
    }

    public function destroy(Group $group)
    {

        $this->groupService->destroy($group);

        return response()->json([
            'message' => "\"{$group->name}\" group has been successfully deleted!"
        ]);
    }
}
