<?php

namespace App\Http\Controllers\Metrics\Wizard;

use App\Models\Resource;
use App\Services\GroupService;
use App\Services\MetricService;
use App\Services\CategoryService;
use App\Http\Controllers\Controller;
use App\Services\DataConnectionService;
use App\Services\DataConnectionTablesService;
use App\Http\Requests\Metrics\ApperanceStepRequest;

class ApperanceStepController extends Controller
{
    public $metricService;
    public $categoryService;
    public $dataConnectionService;
    public $dataConnectionTablesService;
    public $groupService;

    public function __construct(
        MetricService $metricService,
        CategoryService $categoryService,
        DataConnectionService $dataConnectionService,
        DataConnectionTablesService $dataConnectionTablesService,
        GroupService $groupService
    ) {
        $this->metricService               = $metricService;
        $this->categoryService             = $categoryService;
        $this->dataConnectionService       = $dataConnectionService;
        $this->dataConnectionTablesService = $dataConnectionTablesService;
        $this->groupService                = $groupService;
    }

    public function show()
    {

        if (checkDemo()) {
            return $this->edit($this->metricService->getRecentMetric());
        }

        $this->metricService->showMetricTypeStep();

        $metrics = $this->metricService->metricTypes();
        $colors  = $this->metricService->getMetricColors();

        $categories  = $this->categoryService->getCategories();
        $connections = $this->dataConnectionService->getAllConnections();
        $groups      = auth()->user()->isAdminOrOwner() ? $this->groupService->getAllGroups() : [auth()->user()->group];
        $dateRanges  = $this->metricService->dateRanges();

        return view(
            'dashboard.metrics.wizard.index',
            compact(
                'metrics',
                'colors',
                'categories',
                'connections',
                'groups',
                'dateRanges'
            )
        );
    }

    public function store(ApperanceStepRequest $request)
    {
        $this->metricService->storeApperanceStep($request);

        return response()->json([
            'message' => 'success'
        ]);
    }

    public function edit(Resource $metric)
    {
        [
            $metricsTypes,
            $metric,
            $categories,
            $connections,
            $groups,
            $tables,
            $columns,
            $dateTimeColumns,
            $dateRanges,
            $colors
        ] = $this->metricService->edit($metric);

        return view(
            'dashboard.metrics.wizard.edit',
            compact(
                'metricsTypes',
                'metric',
                'categories',
                'connections',
                'groups',
                'tables',
                'columns',
                'dateTimeColumns',
                'dateRanges',
                'colors'
            )
        );
    }

}
