<?php

namespace App\Http\Controllers;

use App\Models\HomeDashboard;
use App\Models\Module;
use App\Services\HomeService;
use App\Services\ModuleService;
use App\Services\ResourceService;

class ResourceController extends Controller
{
    private $moduleService;
    private $resourceService;

    public function __construct(ModuleService $moduleService, ResourceService $resourceService)
    {
        $this->moduleService = $moduleService;
        $this->resourceService = $resourceService;
    }
    public function getAllResourcesByModuleId($module)
    {
        return response()->json([
            "success" => true,
            "data" => [
                'resources' => $this->resourceService->getAllResourceByModuleId($module)
            ->select(['id','name'])
            ->get(),
                'can_add' => Module::find($module)->checkWhoCanAccessModule() || auth()->user()->isAdminOrOwner()
            ]
        ]);

    }
}
