<?php

namespace App\Http\Middleware;

use Closure;
use App\Exceptions\InvalidSignatureException;
use Illuminate\Routing\Middleware\ValidateSignature as MiddlewareValidateSignature;

class ValidateSignature extends MiddlewareValidateSignature
{
    /**
     * The names of the query string parameters that should be ignored.
     *
     * @var array<int, string>
     */
    protected $except = [

// 'fbclid',

// 'utm_campaign',

// 'utm_content',

// 'utm_medium',

// 'utm_source',
        // 'utm_term',
    ];

    public function handle($request, Closure $next, ...$args)
    {
        [$relative, $ignore] = $this->parseArguments($args);

        if ($request->hasValidSignatureWhileIgnoring($ignore, !$relative)) {
            return $next($request);
        }

        throw new InvalidSignatureException;
    }

}
