<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TestSMTPConnectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'smtp_server' => ['required'],
            'smtp_port'   => ['required'],
            'username'    => ['required'],
            'password'    => ['required'],
            'encryption'  => ['required'],
            'auth_mode'   => ['required'],
            'confirmed'   => ['nullable']
        ];
    }

    public function messages()
    {
        return [
            '*.required' => 'SMTP connection parameters cannot be left blank.'
        ];
    }
}
