<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOrganizationDetailsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'max:255'],
            'contact_info' => ['nullable', 'max:255'],
            'tax_info' => ['nullable', 'max:255']

        ];
    }

    public function message()
    {
        return [
            'name.required' => 'Organization name can\'t be empty.',
            'contact_info.max' => 'Organization Contact information can\'t exceed 255 characters.',
            'tax_info.max' => 'Organization Tax info can\'t exceed 255 characters.',
        ];
    }
}