<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class updateDataConnectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            "connection_name" => ["required", "min:3", "max:50", Rule::unique("{$prefix}dataconnections", 'connection_name')
                ->ignore($this->route('connection')->id)],
            "database_type" => ["required"],
            "server" => ["required"],
            "database" => ["required"],
            "username" => ["required"],
            "password" => ["required"],
            "port" => ["nullable", "numeric"],
            "charset" => ["nullable"],
            "collation" => ["nullable"],
        ];
    }

    public function messages()
    {
        return [
            "*.required" => ":attribute can't be empty.",
            "connection_name.min" => "Connection name length should be between 3 and 50 characters",
            "connection_name.max" => "Connection name length should be between 3 and 50 characters",
            "connection_name.unique" => "This connection name is already existed, please use a unique connection name",
        ];
    }
}
