<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ResetPasswordConfirmationMail implements MailInterface
{

    use MailTrait;

    public $user;

    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function send()
    {
        $this->buildMailMessage("Password Reset Confirmation");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }


    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username = $this->username;
        $signature = $this->signature;
        $time = date('Y-m-d H:i:s');
        $ip_address = request()->server("REMOTE_ADDR");

        $this->content = view(
            'auth.mails.confirm',
            compact('username', 'signature', 'time', 'ip_address')
        )->render();
    }
}
