<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DataConnection extends Model
{
    use HasFactory, SoftDeletes;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'connection_name',
        'db_type',
        'server',
        'db',
        'connection_string'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}dataconnections";
    }

    public function resources()
    {
        return $this->hasMany(Resource::class, "data_connection_id");
    }
}
