<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino 
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 *
 */
if (!defined("DIRECTACESS"))
    exit("No direct script access allowed");

class captcha {

    // length of the security code
    var $length_of_code;
    // the security code
    var $code;
    // the characters array from which the security code is formed
    var $characters;
    // the session key , in which the captcha code should be stored
    var $captcha_session_key;
    // directory of the font directory
    var $font_dir;
    // errors while creating captcha
    var $error;

    public function __construct($captcha_session_key, $length_of_code = 6) {
        $this->length_of_code = $length_of_code;
        $this->captcha_session_key = $captcha_session_key;
        if (!isset($_SESSION [$this->captcha_session_key])) {
            $_SESSION [$this->captcha_session_key] = array();
            $_SESSION [$this->captcha_session_key] ["error"] = "";
        }
        $this->error = "";
        $this->characters = "ABCDEFGHIJKLMNOPQRSTUVWXZ123456789";
          $temp_path_array = explode("shared",__DIR__);
          $fixed_part = $temp_path_array[0];
          if(file_exists($temp_path_array[0].'shared/fonts/times_new_yorker.ttf'))
            $this->font_dir = $temp_path_array[0].'shared/fonts/times_new_yorker.ttf';
          
    }

    /*
     * get_code
     * @ Returns the captcha security code.
     */

    public function get_code() {
        if (!empty($this->code)) {
            return $this->code;
        } else {
            return false;
        }
    }

    /*
     * set_characters
     * set the alphanumeric characters that the security code could be generated from
     * @param(characters) the alphanumeric characters that the security code should be generated from
     */

    public function set_characters($characters) {
        if (!empty($characters) && ctype_alnum($characters))
            $this->characters = $characters;
    }

    /*
     * generate_security_code
     * Cgenerate the security token and add it to the captcha session key
     * @ Returns the security code
     */

    public function generate_security_code() {
        $token = '';
        $max_length = strlen($this->characters) - 1;
        for ($i = 0; $i < $this->length_of_code; $i ++) {
            $token .= $this->characters [mt_rand(0, $max_length)];
        }
        $_SESSION [$this->captcha_session_key] ["code"] = $token;
        $this->code = $token;
        return $token;
    }

    /*
     * check_code
     * Check if the code provided by the user is correct
     * @param(entered_code) coded entered by the user
     * @ Returns true if code is correct, and valse otherwise
     */

    public function check_code($entered_code) {
        if (strlen($entered_code) == $this->length_of_code && strtoupper($entered_code) == strtoupper($_SESSION [$this->captcha_session_key] ["code"])) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * get_error
     * @ Returns any errors generated by the captcha *
     */

    public function get_error() {
        return $this->error;
    }

    /*
     * render_captcha
     * Creates the captcha image *
     *
     * @return void .
     */

    public function render_captcha() {

        if (extension_loaded("gd")) {

            // Create the image
            $im = imagecreatetruecolor(400, 30);
            if ($im) {
                // Create some colors
                $white = imagecolorallocate($im, 255, 255, 255);
                $grey = imagecolorallocate($im, 243, 241, 239);
                $red = imagecolorallocate($im, 200, 100, 90);
                imagefilledrectangle($im, 0, 0, 399, 29, $grey);
                // Add some shadow to the text
                imagettftext($im, 20, 0, 11, 21, $grey, $this->font_dir, $this->code);


                // Add the text
                imagettftext($im, 20, 0, 10, 20, $red, $this->font_dir, $this->code);

                // random lines
                for ($i = 0; $i < 3; $i ++) {
                    imagesetthickness($im, 1);
                    imageline($im, 0, rand(0, 29), 150, rand(0, 29), $grey);
                }
                imagepng($im);
                imagedestroy($im);
            } else {
                $this->error = "error in function: imagecreatetruecolor ";
                $_SESSION [$this->captcha_session_key] ["error"] = $this->error;
            }
        } else {
            $this->error = "library gd is not installed";
            $_SESSION [$this->captcha_session_key] ["error"] = $this->error;
        }
    }

    /*
     * test_captcha
     *
     * check if there are any problems that could prevent the captcha from appearing so it should be called before the render function
     * @return true if there is no errors, and false otherwise
     */

    public function test_captcha() {
        ob_start();
        $this->render_captcha();
        ob_end_clean();
        if (!extension_loaded("gd") || !empty($this->error)) {
            return false;
        } else {
            return true;
        }
    }

}

?>