<?php

/**
 *
 * @author A.karim
 */
interface dashboard_interface {
 /*
 * ===============================================================================
 *               Security methods to ptotect reports and wizard 
 * ===============================================================================
 */

    public function get_report_access_type($report_id); 
    public function get_private_report_permissions($report_id);
    public function get_wizard_permissions();
    
 /*
 * ===============================================================================
 *               Connection step in wizard
 * ===============================================================================
 */

    public function get_connection_details($connection_string_name);

    public function get_default_connection_details();

    public function get_all_connection_names();
 /*
 * ===============================================================================
 *               Groups and Categories steps in wizard
 * ===============================================================================
 */

    public function get_all_categories_names();

    public function get_all_groups_names();
    
    public function get_existed_name($report_id);
 /*
 * ===============================================================================
 *              Creating a new report in Engine
 * ===============================================================================
 */
    public function save_new_blank_report($name, $category_id, $connection_name, $creator, $access_level = private_report);

    public function save_private_report_permissions($blank_report_id, $group_ids);

    public function save_resource_configurations($blank_report_id, $configuration_session_object);

    public function is_report_existed_by_url($url);

    public function is_report_existed_by_id($report_id);
  /*
 * ===============================================================================
 *              Editing an existing report 
 * ===============================================================================
 */

    public function change_private_report_permissions($report_id, $group_ids);

    public function edit_blank_report($report_id,$name, $category_id, $connection_name, $creator, $access_level = private_report);

    public function edit_resource_configurations($blank_report_id, $new_configuration_session_object);
/*
 * ===============================================================================
 *             Loading report options in wizard 
 * ===============================================================================
 */
    public function load_report_configurations($blank_report_id);
    public function unload_report_configurations();
      /*
     * ===============================================================================
     *              Deleting a report and all its permissions
     * ===============================================================================
     */
   public function delete_report_with_permissions($report_id);
}
