<?php

/**
 * Smart Reporting Package
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : https://mysqlreports.com/
 */
class Access_control extends access_control_abstract
{

    public function __construct($user_session_data, $dashboard)
    {

        if (is_array($user_session_data) && isset($user_session_data[srm_access_session_key]) && is_array($user_session_data[srm_access_session_key])) {
            $this->user_session = $user_session_data[srm_access_session_key];
        } else {
            $this->user_session = array();
        }

        $this->dashboard = $dashboard;
    }

    /**
     * get all groups that should has access to this resource if any
     */
    protected function get_resource_access_groups($resource)
    {
        return $this->dashboard->get_private_report_permissions($resource);
    }

    /**
     * get all groups that can access wizard if any
     */
    protected function get_wizard_access_groups()
    {
        return $this->dashboard->get_wizard_permissions();
    }

    /**
     * get resource type "public","private" or "admin_only".
     */
    protected function get_resource_type($resource)
    {

        return $this->dashboard->get_report_access_type($resource);
    }

    /**
     * get resource creator "public","private" or "admin_only".
     */
    protected function get_resource_creator($resource)
    {

        return $this->dashboard->get_report_access_creator($resource);
    }

    /**
     * check the user current group can access this resource
     */
    protected function check_group_access_wizard()
    {

        if (strtolower($this->user_saved_role) == "admin") {
            return true;
        } else {
            $allowed_groups = $this->get_wizard_access_groups();

            if (is_array($allowed_groups) && in_array($this->user_saved_group, $allowed_groups)) {
                return true;
            } else {
                srm_dashboard::log('403 Access.', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_warning, "report_builder_engine", "", json_encode($_SESSION[Session_security_key]));
                return false;
            }

        }

    }

    /**
     * check the user current group can access this resource
     */
    protected function check_group_access_resource($resource)
    {

        if (strtolower($this->user_saved_role) == "admin") {
            return true;
        } else {
            $allowed_groups = $this->get_resource_access_groups($resource);

            if (is_array($allowed_groups) && in_array($this->user_saved_group, $allowed_groups)) {
                return true;
            } else {
                srm_dashboard::log('403 Access.', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_warning, "report_builder_engine", "", json_encode($_SESSION[Session_security_key]));
                return false;
            }

        }

    }

}