@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css') }}" />

<link rel="stylesheet" href="{{ get_asset('dist/css/c3.custom.css') }}" />
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
</style>
@endsection


@section('content')

<div class="content-wrapper" style="">
    <script src="{{ get_asset('dist/js/moment.min.js')}}"></script>
    <script src="{{ get_asset('dist/js/d3.v5.min.js')}}"></script>
    <script src="{{ get_asset('dist/js/c3.min.js')}}"></script>

    @include('dashboard.charts.partials._charts-confirmation-modal',[
    'id' => 'delete-chart',
    'modal_title' =>'Delete Confirmation',
    'method'=> 'DELETE'
    ])

    <div id="change-category-modal-container">
    </div>
    @if((isset($chartModule) && $chartModule->checkWhoCanAccessModule()) ||
    auth()->user()->isAdminOrOwner())
    @include('dashboard.charts.iframe.create')
    @endif
    @include('dashboard.charts.iframe.edit')
    @include('dashboard.charts.partials.success-modal')
    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fas fa-chart-line fa-fw"></i>
                        Charts</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Charts</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
        <div class="container-fluid chart-parent-container">

            <div>
                <form action="{{ route('charts.index') }}" method="GET" id="chart-search-form">
                    <div class="bg-white py-3">
                        <div class="row bg-white mx-3 row-no-padding-left">
                            <div class="col">
                                <label class="sr-only" for="inlineFormInputGroup">Name</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Name</div>
                                    </div>
                                    <input type="text" class="form-control rounded-small" id="chart-name"
                                        placeholder="Search" name="chartName" value="{{ request()->chartName }}">
                                    <i class="fa fa-search"></i>

                                </div>
                            </div>
                            <div class="col">
                                <label class="sr-only" for="inlineFormInputGroup">Title</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Title</div>
                                    </div>
                                    <input type="text" class="form-control rounded-small" id="chart-title"
                                        placeholder="Search" name="chartTitle" value="{{ request()->chartTitle }}">
                                </div>
                            </div>

                            <div class="col">
                                <label class="sr-only" for="inlineFormInputGroup">Chart</label>
                                <div class="input-group input-box">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text rounded-small">Chart</div>
                                    </div>
                                    <select type="text" class="form-control rounded-small" id="chart-type"
                                        placeholder="search" name="chartType">
                                        <option value="">Please Choose Chart Type</option>
                                        @foreach ($chartTypes as $chartType)
                                        <option value="{{ $chartType['value'] }}" {{ request()->chartType ==
                                            $chartType['value'] ? 'selected' : ''}} >{{
                                            $chartType['label'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center mt-3">
                        <button class="btn btn-primary ml-2 py-2 px-3 srm-button" id="chart-search" type="submit">
                            <i class="fas fa-search"></i> Search
                        </button>

                        <button class="btn btn-outline-primary px-3 py-2 my-sm-0 srm-button show-all" type="button"><i
                                class="fa-solid fa-eye"></i> Show All</button>

                    </div>

                </form>
            </div>
            <div class="mt-4">
                @if((isset($chartModule) && $chartModule->checkWhoCanAccessModule()) ||
                auth()->user()->isAdminOrOwner())
                <button class="btn btn-primary float-right px-3 py-2 srm-button" type="button" id="add-chart-button"
                    data-url="{{ route('charts.wizard.appearance.show') }}"
                    data-forget="{{ route('charts.forgetSession') }}">
                    <i class="fas fa-plus"></i> Add New Chart
                </button>
                @endif
            </div>
            <div class="clearfix"></div>
            <div class="chart-container" style="min-height:40vh">

                <div class="charts mt-4">
                    @if(!empty($charts[0]))

                    <div class="loader" style="display: none">
                        <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                    </div>

                    <div class="row">
                        @php
                        $previousChartSize = '';
                        @endphp

                        @foreach($charts as $chart)

                        @if(!is_null($chart))

                        @php
                        $currentChartSize = $chart->getResourceConfiguration('widget_size');
                        @endphp

                        <div @if($chart->isChartFullSize())
                            class="col-md-12 col-12"
                            @else
                            class="col-md-6 col-12"
                            @endif
                            >
                            <div class="card card-primary card-outline">
                                @php
                                $chartID = Str::of($chart->name)->kebab();
                                @endphp
                                <div class="loader" style="display: none">
                                    <img src="{{get_asset('dist/images/loader.gif')}}" class="loader-img" alt="Loader">
                                </div>

                                <div class="card-header">
                                    <h3 class="card-title" style="color:black;font-weight:bold">
                                        @if($chart->getResourceConfiguration('chart_link'))
                                        <a href="{{ route('charts.details',$chart->id) }}" style="color:black">{{
                                            $chart->getResourceConfiguration('title') }}</a>
                                        @else
                                        {{ $chart->getResourceConfiguration('title') }}
                                        @endif

                                    </h3>
                                    <div class="card-tools">
                                        @if(
                                        (
                                        isset($chart->creator) &&
                                        $chart->creator->user_ID == auth()->user()->user_ID
                                        )
                                        ||
                                        auth()->user()->isAdminOrOwner()
                                        || $chart->getResourceConfiguration('chart_link')
                                        )

                                        <div class="dropdown">
                                            <button type="button" id="ellipsisMenu2" data-toggle="dropdown"
                                                aria-haspopup="true" aria-expanded="false"
                                                style="border:none;background:none">
                                                <!-- Your SVG icon -->
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-three-dots-vertical"
                                                    viewBox="0 0 16 16">
                                                    <path
                                                        d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z">
                                                    </path>
                                                </svg>
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-right"
                                                aria-labelledby="ellipsisMenu">
                                                @if($chart->getResourceConfiguration('chart_link'))

                                                <a class="dropdown-item display-report"
                                                    data-url="{{ route('charts.details',$chart->id) }}"
                                                    href="{{ route('charts.details',$chart->id) }}">Display</a>
                                                @endif
                                                @if(
                                                (
                                                isset($chart->creator) &&
                                                $chart->creator->user_ID == auth()->user()->user_ID
                                                )
                                                ||
                                                auth()->user()->isAdminOrOwner())
                                                <a class="dropdown-item edit-chart"
                                                    data-url="{{ route('charts.wizard.appearance.edit',$chart->id) }}">Edit</a>

                                                <a class="dropdown-item change-category"
                                                    data-url="{{ route('charts.getCategories',$chart->id) }}">Change
                                                    category</a>

                                                <a class="dropdown-item delete-chart" data-toggle="modal"
                                                    data-target="#delete-chart-modal"
                                                    data-url="{{ route('charts.destroy',$chart->id) }}">Delete</a>
                                                @endif
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-body" style="min-height: 350px">
                                    @php
                                    $chartID = Str::of($chart->name)->kebab();
                                    @endphp
                                    <div id="{{ $chartID }}"></div>
                                    <div id="{{ $chartID }}-error" class="error text-danger text-center"></div>
                                    <script>
                                        getChartScript('{{ route("charts.build",[$chart->id]) }}','{{ $chartID }}')
                                    </script>
                                </div>
                            </div>

                        </div>
                        @php
                        $previousChartSize = $currentChartSize;
                        @endphp

                        @if($loop->first && $chart->getResourceConfiguration('widget_size') == "half" &&
                        (!request()->has('page') || request()->get('page') == 1))
                        <div class="col-md-6 col-12">
                        </div>
                        @endif
                        @endif
                        @endforeach
                    </div>

                    @else
                    @if($search)
                    <div class="text-center message">
                        <h6>No records matches your search criteria.</h6>
                    </div>
                    @else
                    <div class="text-center message">
                        <h6>No charts to preview.</h6>
                    </div>
                    @endif
                    @endif

                </div>

            </div>
            @if($charts->lastPage() > 1)
            <div class="float-right">
                {{ $charts->appends(request()->query())->links() }}
            </div>
            <div class="clearfix"></div>
            @endif

    </section>

</div>
@endsection


@section('scripts')
<script src="{{ get_asset('dist/js/charts.js')}}"></script>
<script>
    d3.selectAll(".c3")
    .selectAll("text")
    .style("font-family", "poppins, arial")

</script>

@if(session('add'))

<script>
    window.onload= function(){
        $('#add-chart-button').click();
    }
</script>

@endif

@endsection
