<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Smart Report Maker</title>
    <link rel="stylesheet" href="{{ public_path('dist/css/all.min.css')}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/adminlte.min.css')}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/style.css')}}" />
    {{--
    <link rel="stylesheet" href="{{ public_path('dist/css/metrics.css') }}" /> --}}

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }

        table td,
        table th,
        table {
            word-wrap: break-word;
            /* For non-IE */
            overflow-wrap: break-word;
            /* For IE */
            word-break: break-all;
            /* Force breaking long words and URLs */
        }

        .tooltip-red {
            color: #bb2124;
            font-weight: bold;
        }

        .tooltip-green {
            color: #22bb33;
            font-weight: bold;
        }
    </style>

<body>

    <div class="content-wrapper" style="background-color:white !important">
        <section class="content-header">
            <div class="row">
                <div class="col-sm-7 float-left">
                    <h2 style="font-weight: bold">{{ucwords($metric->getResourceConfiguration('name')) }}</h2>
                    <h6>{{ $metric->created_at->format('d M Y h:i A') }}
                    </h6>
                </div>
                <div class="col-sm-4 text-right float-right">
                    <div class="branding-logo">
                        @if(is_null(getSettingsValue('system_logo')))
                        <img src="{{ public_path('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image" />
                        @else
                        <img src="{{ getSystemLogo(true) }}" alt="Logo" class="brand-image w-100" />
                        @endif
                    </div>

                </div>
                <div style="clear:both"></div>
                <div class="col-sm-7">
                    {!! $metric->drillTooltip !!}
                </div>

            </div>

            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">

            <div class="table table-bordered">
                <table width="100%" style="table-layout:fixed;">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            @foreach($keys as $key)
                            @if(count($keys) > 5)
                            <th>
                                <div style="font-size:0.8rem;{{ strlen($key) > 8 ? 'font-size:0.6rem' : '' }}">
                                    {{ $key }}
                                </div>
                            </th>
                            @else
                            <th>
                                <div>
                                    {{ $key }}
                                </div>
                            </th>
                            @endif
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($data) > 0)
                        @foreach($data as $row)
                        @if(count($keys) > 7)

                        <tr class="smaller-font">
                            @foreach($row as $item)
                            <td>
                                <div style="font-size:0.8rem;{{ strlen($item) > 20 ? 'font-size:0.6rem' : '' }}">
                                    {{$item}}
                                </div>
                            </td>
                            @endforeach
                        </tr>
                        @else
                        <tr class="smaller-font">
                            @foreach($row as $item)
                            <td>
                                {{$item}}
                            </td>
                            @endforeach
                        </tr>

                        @endif
                        @endforeach
                        @else
                        <tr style="background-color:transparent">
                            <td style="text-align: center" colspan="{{ count($keys) }}">
                                <h6>Sorry, There is no data</h6>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>

            </div>
            <div class="pt-5">
                <img src="{{ $image }}" alt="Chart Image" class="p-0 m-0 w-100" style="width:100%">
            </div>

    </div>
</body>
