@extends('layouts.app')

@section('styles')
<style>
    .content-wrapper>* {
        font-family: 'poppins', 'arial';
    }
</style>
<link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css') }}" />
<style>
    table {
        width: 100%;
        border-collapse: collapse;
    }

    table td,
    table th,
    table {
        word-wrap: break-word;
        /* For non-IE */
        overflow-wrap: break-word;
        /* For IE */
        word-break: break-all;
        /* Force breaking long words and URLs */
    }
</style>
@endsection

@section('content')



<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid px-4">
            <div class="row mt-2">
                <div class="col-sm-6">
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('scheduled-reports.index') }}">Schduled Reports
                                Tasks</a></li>
                        <li class="breadcrumb-item">{{ $scheduledTask->title }}</li>
                    </ol>
                </div>
            </div>
            <div class="row mb-2 mt-2">
                <div class="col-sm-8">
                    <h2 style="font-weight: bold">{{ ucwords($scheduledTask->title) }} log
                    </h2>
                    <h6>{{ $scheduledTask->created_at->format('d M Y h:i A') }}</h6>
                </div>
                <div class="col-sm-4 text-right">
                    <div class="p-2 branding-logo">
                        @include('partials._logo')
                    </div>
                </div>
            </div>
            <hr style="border-top: 1px solid rgba(0, 0, 0, .5);">
        </div>
        <div class="container-fluid mt-4 px-4">

            <div class="table table-bordered table-striped">
                <table id="reports" width="100%" style="table-layout:fixed">
                    <thead>
                        <tr style="background-color: #d6d8da">
                            <td>Start sending</td>
                            <td>End sending</td>
                            <td>Status</td>
                            <td style="width: 40%">Error</td>
                            <td>Success rate</td>
                        </tr>
                    </thead>
                    <tbody>
                        @if(count($logs) > 0)
                        @foreach($logs as $log)
                        <tr class="smaller-font">
                            <td>{{ $log->start_sending_date }}</td>
                            <td>{{ $log->end_sending_date }}</td>
                            <td>{{ $log->status }}</td>
                            <td>{{ $log->error_message }}</td>
                            <td>
                                <div class="progress progress-xs">
                                    <div class="progress-bar progress-bar-danger"
                                        style="width: {{ $log->successRate() }}%"></div>
                                </div>
                                <div class="text-center mt-2">{{ $log->successRate() }}%</div>
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr style="background-color:transparent">
                            <td style="text-align: center" colspan="5">
                                <h6>Sorry, There is no data</h6>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="clearfix"></div>
        </div>

</div>


@endsection