<?php $__env->startSection('styles'); ?>

<style>
    div.custom-control-right {
        padding-right: 24px;
        padding-left: 0;
        margin-left: 0;
        margin-right: 0;
    }

    div.custom-control-right .custom-control-label::after {
        right: -1.5rem;
        left: auto;
    }

    div.custom-control-right .custom-control-label::before {
        right: -2.35rem;
        left: auto;
    }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><i class="fa-solid fa-wrench mx-2"></i> General</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">General</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-lg-6">
                    <div class="card bg-white">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title font-weight-bold">
                                    <i class="fa-solid fa-gear mr-2"></i>General
                                    Settings
                                </h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="general-settings-form" data-url="<?php echo e(route('general.update')); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-group">
                                    <div class="custom-control custom-control-right custom-switch d-flex">
                                        <input type="checkbox" class="custom-control-input" id="allow-register"
                                            name="allow_register" <?php echo e(isset($settings["user_registeration_is_enabled"])
                                            && $settings["user_registeration_is_enabled"] ? 'checked' :''); ?> value="1">
                                        <label class="custom-control-label" for="allow-register">Allow User
                                            Registeration</label>
                                        <span class="tool-question mx-5 align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="When enabling 'allow user registration,' a link in your login form will be available for new users to register on the system as normal users. However, their status will be pending until an admin activates their subscription and assigns them to a group.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="organizationContactInformation">From Name</label>
                                    <div class="d-flex">
                                        <input type="text" class="form-control" id="from-name" name="from_name"
                                            placeholder="First Name" <?php if(checkDemo()): ?> value="<name>" <?php else: ?>
                                            value="<?php echo e(isset($settings['fromName']) ? $settings['fromName'] :''); ?>"
                                            <?php endif; ?> />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="Enter the display name or sender's name that you want to appear in the 'From' field of any email notification sent from the system to your users. This name provides a recognizable sender identity to your recipients. For example, you can use your company name or your personal name. It will be shown as '<From Name> <from email>' in the recipient's email client.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="from-email">From Email</label>
                                    <div class="d-flex">
                                        <input type="text" class="form-control" id="from-email" name="from_email"
                                            placeholder="First Email" <?php if(checkDemo()): ?> value="<Email>" <?php else: ?>
                                            value="<?php echo e(isset($settings['fromEmail']) ? $settings['fromEmail'] :''); ?>"
                                            <?php endif; ?> />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top" title="All emails sent from Smart Report Maker will have this email address as the '
                                            From' and 'Reply To' address.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="mail-signature">Email Signature</label>
                                    <div class="d-flex">
                                        <textarea type="text" class="form-control" id="mail-signature"
                                            name="mail_signature"><?php if(checkDemo()): ?>signature <?php else: ?><?php echo e(isset($settings['mail_signature']) ? $settings['mail_signature'] :''); ?><?php endif; ?></textarea>
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="Enter the email signature text that you want to include at the end of all email notifications sent by the system. > Max length is 255 characters.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="">Time Zone</label>
                                    <div class="d-flex">
                                        <select class="form-control timezone" id="timezone" name="timezone">
                                            <option value="">Select Time Zone</option>
                                            <?php $__currentLoopData = getTimeZones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $identifier => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($identifier); ?>" <?php echo e((isset($settings["timezone"]) &&
                                                $settings["timezone"]===$identifier ) ? 'selected' : ''); ?>>
                                                <?php echo e($timezone); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>

                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="This time zone will be utilized throughout the system, particularly in any scheduled processes.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>
                                <?php if(!(isDocker() || isHostedVersion() || checkDemo())): ?>
                                <div class="form-group">
                                    <label for="taxInfo">Needed CronJob

                                        <span class="tool-question" data-toggle="tooltip" data-placement="top"
                                            title="The system requires a single cron job, which the installer script (.sh or .ps1) should have automatically set up for you. However, it’s recommended to double-check that the cron job exists, as there may be rare situations where the setup could be missed. If it's missing, please create it manually. This cron job should run every minute to execute the specified PHP script.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>

                                    </label>

                                    <div class="d-flex">
                                        <ul>
                                            <li>The system requires a single cron job, which the installer script (.sh
                                                or .ps1) should have automatically set up for you. However, it’s
                                                recommended to double-check that the cron job exists, as there may be
                                                rare situations where the setup could be missed. If it's missing, please
                                                create it manually. This cron job should run every minute to execute the
                                                specified PHP script.</li>
                                            <?php if(config('srm_config.installer.cronjob')): ?>
                                            <ul>

                                                <li>
                                                    <code class="srm-code"><?php echo e(getCronJobScript()); ?></code>
                                                </li>
                                            </ul>
                                            <li>The command executed by the cronjob depends on the PHP executable path
                                                and other factors you should verify. Here's an example:</li>
                                            <ul>
                                                <li>
                                                    <code class="srm-code">
                                                        * * * * * <?php echo e(getCronJobScript(true,"php")); ?>

                                                    </code>
                                                </li>
                                            </ul>
                                        </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-control-right custom-switch d-flex">
                                        <input type="checkbox" class="custom-control-input" id="cronjobs-created"
                                            name="cronjobs_created" checked>
                                        <label class="custom-control-label" for="cronjobs-created">Cronjobs created as
                                            Needed</label>
                                        <span class="tool-question mx-5 align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="In this field, you need to confirm that you've set up the cronjobs mentioned in the previous section. Smart Report Maker relies on these cronjob to send regular reports via email.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="text-center">
                                    <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save"
                                        id="saveBtn-general-settings">

                                    <input type="button" class="btn btn-secondary mx-2 px-5 py-2"
                                        id="cancelBtn-general-settings" value="Cancel">

                                </div>

                                <div id="confirm-general-settings" class="alert bootstrap-alert-success my-2"
                                    role="alert" style="display: none">
                                </div>

                                <div id="error-general-settings" class="alert bootstrap-alert-danger my-2" role="alert"
                                    style="display: none">
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card bg-white">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title font-weight-bold">
                                    <i class="fa-solid fa-paint-brush mr-2"></i>Branding
                                </h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-3">
                                    <label>System Logo</label>
                                </div>
                                <div class="col-6 branding-logo">
                                    <img src="<?php echo e(getSystemLogo()); ?>" alt="" style="width: 100%">
                                </div>
                                <div class="col-3">
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#branding-logo">
                                                Change
                                            </button>
                                            <span class="tool-question mx-4 d-flex align-items-center"
                                                data-toggle="tooltip" data-placement="top"
                                                <?php if(!is_null(config('srm_config.dashboard.system_logo'))): ?>
                                                title="Replace the default system logo by uploading your own image. Ensure your logo should have the following dimension <?php echo e(config('srm_config.dashboard.system_logo.width', 370)); ?> X <?php echo e(config('srm_config.dashboard.system_logo.height', 70)); ?>">
                                                <?php endif; ?>
                                                <i class="fa-solid fa-circle-question"></i>
                                            </span>

                                            <?php echo $__env->make('dashboard.general.partials._logo-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card bg-white">
                        <div class="card-header">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title font-weight-bold">
                                    <i class="fa-solid fa-envelope mr-2"></i>SMTP Server
                                </h3>
                            </div>
                        </div>
                        <form id="smtp-server-form" data-url="<?php echo e(route('smtp_servers.update')); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('POST'); ?>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="smtp-server">SMTP Server</label>
                                    <div class="d-flex">
                                        <input type="text" class="form-control" id="smtp-server" name="smtp_server"
                                            placeholder="SMTP Server" <?php if(checkDemo()): ?> value="<host>" <?php else: ?>
                                            value="<?php echo e(isset($smtp->smtp) ? $smtp->smtp : ''); ?>" <?php endif; ?> />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="This is the server address used for sending emails. It's typically provided by your email service provider. Example: smtp.yourprovider.com">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="smtp-port">SMTP Port</label>
                                    <div class="d-flex">
                                        <input type="number" class="form-control" id="smtp-port" name="smtp_port"
                                            placeholder="SMTP Port"
                                            value="<?php echo e(isset($smtp->port) ? $smtp->port : ''); ?>" />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="This specifies the communication endpoint on the server. default ports for SMTP include 25 (non-encrypted), 465 (SSL/TLS), or 587 (STARTTLS)">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="username">User Name</label>
                                    <div class="d-flex">
                                        <input type="text" class="form-control" id="username" name="username"
                                            placeholder="User Name" <?php if(checkDemo()): ?> value="<username>" <?php else: ?>
                                            value="<?php echo e(isset($smtp->username) ? $smtp->username : ''); ?>" <?php endif; ?> />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="Your username or email address associated with the SMTP server. This is used for authentication to send emails">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="username">Password</label>
                                    <div class="d-flex">
                                        <input type="password" class="form-control" id="password" name="password"
                                            placeholder="Password" value="" />
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="The password linked with the provided username/email for authentication purposes. Keep this confidential.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>

                                    </div>
                                </div>


                                <div class="form-group">
                                    <label for="securityQuestion">Encryption</label>
                                    <div class="d-flex">
                                        <select class="form-control" name="encryption" id="encryption">
                                            <option value="none" <?php echo e(isset($smtp->encryption) && ($smtp->encryption ===
                                                "none") ? 'selected' : ''); ?>>None (No Encryption)</option>
                                            <option value="tls" <?php echo e(isset($smtp->encryption) && ($smtp->encryption ===
                                                "tls") ? 'selected' : ''); ?>>TLS (Transport Layer Security)</option>
                                            <option value="ssl" <?php echo e(isset($smtp->encryption) && ($smtp->encryption ===
                                                "ssl") ? 'selected' : ''); ?>>SSL (Secure Sockets Layer)</option>
                                            <option value="star-tls" <?php echo e(isset($smtp->encryption) && ($smtp->encryption
                                                ==="tls") ? 'selected' : ''); ?>>STARTTLS</option>
                                            <option value="auto" <?php echo e(isset($smtp->encryption) && ($smtp->encryption
                                                ==="auto") ? 'selected' : ''); ?>>Auto (Automatic Detection)</option>
                                        </select>
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="Select the type of security encryption used for the connection. Options might include 'None' for no encryption, 'SSL' or 'TLS' for secure encrypted connections.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>

                                </div>

                                <div class="form-group">
                                    <label for="securityQuestion">Authentication Mode</label>
                                    <div class="d-flex">
                                        <select class="form-control" name="auth_mode" id="auth-mode">
                                            <option value="PLAIN" <?php echo e(isset($smtp->auth_mode) && ($smtp->auth_mode
                                                ==="PLAIN") ? 'selected' : ''); ?>>PLAIN</option>
                                            <option value="LOGIN" <?php echo e(isset($smtp->auth_mode) && ($smtp->auth_mode
                                                ==="LOGIN") ? 'selected' : ''); ?>>LOGIN</option>
                                            <option value="CRAM-MD5" <?php echo e(isset($smtp->auth_mode) && ($smtp->auth_mode
                                                ==="CRAM-MD5") ? 'selected' : ''); ?>>CRAM-MD5</option>
                                        </select>
                                        <span class="tool-question mx-2 d-flex align-items-center" data-toggle="tooltip"
                                            data-placement="top"
                                            title="This determines the method used to authenticate with the SMTP server. Options often include 'Plain,' 'Login,' or 'CRAM-MD5' among others.">
                                            <i class="fa-solid fa-circle-question"></i>
                                        </span>
                                    </div>
                                </div>

                                <div class="col-md-12 text-center">
                                    <button type="button" class="btn btn-primary mx-2 px-4 py-2 my-3"
                                        id="test-smtp-server-connection" data-test=<?php echo e(route('smtp_servers.test')); ?>>
                                        Test Connection
                                    </button>
                                </div>

                                <div class="text-center">
                                    <input type="button" class="btn btn-primary mx-2 px-5 py-2" value="Save"
                                        id="saveBtn-smtp-server">

                                    <input type="button" class="btn btn-secondary mx-2 px-5 py-2"
                                        id="cancelBtn-smtp-server" value="Cancel">

                                </div>

                                <div id="confirm-smtp-server" class="alert bootstrap-alert-success my-2" role="alert"
                                    style="display: none">
                                </div>

                                <div id="error-smtp-server" class="alert bootstrap-alert-danger my-2"
                                    data-toggle="tooltip" role="alert" style="display: none" title="">
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('dashboard.general.partials._smtp-connections-confirm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(get_asset('dist/js/general-settings.js')); ?>" defer>
</script>
<script src="<?php echo e(get_asset('dist/js/branding.js')); ?>" defer></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/mysqlrep/srmtest.mysqlreports.com/srm/dashboard/resources/views/dashboard/general/index.blade.php ENDPATH**/ ?>