<?php

function export_xls_with_subtotals($writer, $limits, $start, $duration, $records_count)
{
    global $sub_totals,$all_records, $sub_totals_obj,$calculated_columns, $fields, $labels;

    // validation of exporting parameters
    $results = validate_export_parameters($limits, $start, $duration, $records_count, true);

    if (isset($calculated_columns) && is_array($calculated_columns)) {
        foreach ($calculated_columns as $key => $value) {
            $fields[] = $key;
            $labels[$key] = $key;
            $cells[$key] = "value";
        }
    }

    if (!empty($results)) {
        foreach ($results as $key => $group) {
            $group_size = count($group);

            foreach ($calculated_columns as $column => $func) {
                $row[$column] = $func($row);
            }

            foreach($labels as $label) {
                $header[$label] = 'string';
            }


            $writer->writeSheetRow('Sheet1', []); // empty row

            // group by rows
            $writer->writeSheetRow('Sheet1', array_values([$sub_totals['group_by'],$key]), ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center","color" => "#337AB7", "font-style" => "bold"]);

            $writer->writeSheetRow('Sheet1', []); // empty row

            $writer->writeSheetHeader('Sheet1', $header, ["valign" => "middle","halign" => "center", "font-style" => "bold","fill" => "#ECF0F1"]);


            // rows of data
            foreach ($group as $row) {
                $writer->writeSheetRow('Sheet1', array_values($row), ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center"]);
            }


            // subtotals
            if (array_keys($results)[count($results) - 1] != $key || $group_size === $sub_totals_obj->get_records_count($key)) {
                $tbl = [];
                $col_index = -1;

                foreach ($fields as $f) {

                    $col_index++;
                    $is_first = ($col_index === 0) ? true : false;
                    if ($is_first) {
                        $tbl[] = $sub_totals_obj->apply_sub_total_function($key, $f, false, $is_first, true);
                    } else {
                        $tbl[] = $sub_totals_obj->apply_sub_total_function($key, $f, false, $is_first, true);
                    }
                }

                $writer->writeSheetRow('Sheet1', $tbl, ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center","fill" => "#E6EEFD","color" => "#337AB7", "font-style" => "bold"]);
            }

        }
    }
    $column_index = -1;
    $tbl = [];
    foreach ($fields as $f) {


        $column_index++;
        $cell_grand_total = $sub_totals_obj->get_grand_totals($f);
        if ($column_index == 0 && empty($cell_grand_total)) {
            $tbl[] = $sub_totals_obj->get_title();
        } else {
            $tbl[] = $cell_grand_total;
        }
    }

    $writer->writeSheetRow('Sheet1', []);// empty row

    $writer->writeSheetRow('Sheet1', [$sub_totals_obj->get_title()], ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center","color" => "#337AB7", "font-style" => "bold"]);

    $writer->writeSheetRow('Sheet1', []);// empty row

    $writer->writeSheetHeader('Sheet1', $header, ["valign" => "middle","halign" => "center", "font-style" => "bold","fill" => "#ECF0F1"]);

    $writer->writeSheetRow('Sheet1', $tbl, ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center","fill" => "#E6EEFD","color" => "#337AB7", "font-style" => "bold","fill_idx" => 0]);

    $filename = explode(".php", $_SESSION["active_report_srm7"])[0];

    if(isset($all_records) && !$limits) {
        $filename = "$filename-allpages.xlsx";
    } else {
        $filename = "$filename-singlepage.xlsx";
    }

    // Send headers to initiate the download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' .$filename . '"');
    header('Cache-Control: max-age=0');


    // Directly output the XLSX content to the browser
    $writer->writeToStdOut();


}


function export_xls_without_subtotals($writer, $limits, $start, $duration, $records_count)
{
    global $sub_totals,$all_records, $sub_totals_obj,$calculated_columns, $fields, $labels;

    // validation of exporting parameters
    $results = validate_export_parameters($limits, $start, $duration, $records_count, false);

    if (isset($calculated_columns) && is_array($calculated_columns)) {
        foreach ($calculated_columns as $key => $value) {
            $fields[] = $key;
            $labels[$key] = $key;
            $cells[$key] = "value";
        }
    }


    foreach($labels as $label) {
        $header[$label] = 'string';
    }

    $writer->writeSheetHeader('Sheet1', $header, ["valign" => "middle","halign" => "center", "font-style" => "bold","fill" => "#ECF0F1"]);


    if (!empty($results)) {

        foreach ($results as $row) {

            $writer->writeSheetRow('Sheet1', array_values($row), ["wrap_text" => true,"font-size" => 12, "valign" => "middle","halign" => "center"]);
        }
    }

    $filename = explode(".php", $_SESSION["active_report_srm7"])[0];

    if(isset($all_records) && !$limits) {
        $filename = "$filename-allpages.xlsx";
    } else {
        $filename = "$filename-singlepage.xlsx";
    }

    // Send headers to initiate the download
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' .$filename . '"');
    header('Cache-Control: max-age=0');

    // Directly output the XLSX content to the browser
    $writer->writeToStdOut();


}
