<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 *
 */

if (!defined("DIRECTACESS")) {
    exit("No direct script access allowed");
}

define("srm_access_session_name", "srm_access_blank");
define("Session_Save_Parameters", 1);
define("Session_report_Settings_key", "srm_report_config");
define("Session_wizard_key", "srm_wizard_config");
define("Session_security_key", "srm_access_session_key");
define("Session_timeout_key", "timeout_srm7");
define("srm_access_session_key", "srm_access_session_key");
// define("srm_access_session_array_keys", array("srm_access_role", "srm_access_userid", "srm_access_username", "srm_access_email", "srm_access_group", "srm_access_ip", "srm_access_user_agent"));
define("srm_access_session_array_keys", array("srm_access_role", "srm_access_userid", "srm_access_username", "srm_access_email", "srm_access_group"));
define("srm_access_role", "srm_access_role");

// define("srm_access_ip", "srm_access_ip");
// define("srm_access_user_agent", "srm_access_user_agent");
define("srm_access_group", "srm_access_group");
define("srm_access_userid", "srm_access_userid");
define("srm_access_username", "srm_access_username");
define("srm_access_email", "srm_access_email");
define("private_report", "Private");
define("public_report", "Public");
define("default_connection_name", "Default");
define("report_base_path", "SRM9/SRM/Reports9/");
define("tables_prefix", "srm_");
define("log_drivers", array("file"));
define("log_diagnostic_mode", "error");
define("log_file_path", "dashboard/storage/logs/");
define("log_file_default_levels", 5);
define("log_stack_trace", 1);
define("online_demo_mode", 0);
// define("online_demo_report_id", "");

session_begin(srm_access_session_name);


function session_begin($session_name)
{

    global $session_timeout, $limited_time_session;
    // Make sure the session cookie is not accessible via javascript.

    $httponly = true;

    // Hash algorithm to use for the session. (use hash_algos() to get a list of available hashes.)
    $session_hash = 'sha512';

    // Check if hash is available
    if (in_array($session_hash, hash_algos())) {
        // Set the has function.
        ini_set('session.hash_function', $session_hash);
    }

    // How many bits per character of the hash.
    // The possible values are '4' (0-9, a-f), '5' (0-9, a-v), and '6' (0-9, a-z, A-Z, "-", ",").
    ini_set('session.hash_bits_per_character', 5);

    // Force the session to only use cookies, not URL variables.
    ini_set('session.use_only_cookies', 1);

    // Get session cookie parameters
    $cookieParams = session_get_cookie_params();
    // Set the parameters
    session_set_cookie_params($cookieParams["lifetime"], $cookieParams["path"], $cookieParams["domain"], $cookieParams["secure"], $httponly);
    // Change the session name
    session_name($session_name);
    // Now we cat start the session
    session_start();

    // This line regenerates the session and delete the old one.
    // It also generates a new encryption key in the database.
    session_regenerate_id();

    //make sure idel time is below the maximum amount $session_timeout

    if (isset($_SESSION[Session_timeout_key])) {
        // calculate the session's "time to live"
        $sessionTTL = time() - $_SESSION[Session_timeout_key];

        if ($sessionTTL > $session_timeout && strtolower($limited_time_session) == "yes") {
            session_end();
            return;
        }

    }

    //first request
    $_SESSION[Session_timeout_key] = time();
}

function session_end()
{

    $_SESSION = array();

    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(
            session_name(),
            '',
            time() - 42000,
            $params["path"],
            $params["domain"],
            $params["secure"],
            $params["httponly"]
        );
    }

    // Finally, destroy the session.
    session_destroy();
    session_unset();
}
